package ru.yandex.client.so.shingler;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.client.so.shingler.config.ShinglerType;

@SuppressWarnings({"unused"})
public class ShinglersData extends HashMap<ShinglerType, AbstractShinglesMap<?>> {
    private boolean isRetry;

    public ShinglersData() {
        isRetry = false;
    }

    public void addAll(final ShinglersData shinglersData) throws ShingleException {
        this.isRetry = shinglersData.isRetry();
        for (final Map.Entry<ShinglerType, AbstractShinglesMap<?>> entry : shinglersData.entrySet()) {
            if (containsKey(entry.getKey())) {
                get(entry.getKey()).addAll(entry.getValue());
            } else {
                put(entry.getKey(), createShinglesData(entry.getKey(), entry.getValue()));
            }
        }
    }

    private AbstractShinglesMap<?> createShinglesData(
        final ShinglerType shinglerType,
        final AbstractShinglesMap<?> data)
        throws ShingleException
    {
        switch (shinglerType) {
            case ACTIVITY:
                return new ActivityShingles((ActivityShingles) data);
            case MASS_IN:
            case MASS_OUT:
                return new MassShinglerResult((MassShinglerResult) data);
            case COMPL:
                return new ComplShingles((ComplShingles) data);
            case DICT:
                return new DictShinglerResult((DictShinglerResult) data);
            case FREEMAIL:
                return new FreemailShingles((FreemailShingles) data);
            case SENDER:
                return new SenderShingles((SenderShingles) data);
            case URL:
                return new UrlShingles((UrlShingles) data);
            default:
                return null;
        }
    }

    public boolean isRetry() {
        return isRetry;
    }

    public void setIsRetry(final boolean isRetry) {
        this.isRetry = isRetry;
    }
}
