package ru.yandex.client.so.shingler;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.errorprone.annotations.NoAllocation;

import ru.yandex.digest.Fnv;
import ru.yandex.function.StringBuilderable;

// Maps ShingleType to shingle hash which is mapped to frequency and values
public class Shingles extends AbstractShinglesMap<Map<Long, Shingle>> {
    public static final Shingles EMPTY = new Shingles();

    private static final long serialVersionUID = 0L;
    private static final String PREFIX = "Shingles(";
    private static final int PREFIX_LENGTH = PREFIX.length();

    public void add(final ShingleType type, final String value) {
        computeIfAbsent(type, x -> new HashMap<>())
            .computeIfAbsent(Fnv.fnv64(value), Shingle::new)
            .add(value);
    }

    public void add(final ShingleType type, final Shingle shingle) {
        computeIfAbsent(type, x -> new HashMap<>()).put(shingle.shingleHash(), shingle);
    }

    @NoAllocation
    @Nonnull
    public Map<ShingleType, Map<Long, Shingle>> stats() {
        return this;
    }

    @SuppressWarnings("unchecked")
    @Override
    public void addAll(final AbstractShinglesMap<?> data) {
        for (final Map.Entry<ShingleType, Map<Long, Shingle>> entry
                : ((AbstractShinglesMap<Map<Long, Shingle>>)data).entrySet()) {
            for (final Map.Entry<Long, Shingle> shingleInfo : entry.getValue().entrySet()) {
                computeIfAbsent(entry.getKey(), x -> new HashMap<>())
                    .put(shingleInfo.getKey(), new Shingle(shingleInfo.getValue()));
            }
        }
    }

    @Override
    public Shingles getEmpty() {
        return EMPTY;
    }

    @Override
    public int expectedStringLength() {
        int len = PREFIX_LENGTH + 4 + 4 * (size() << 1) - 1;
        for (Map.Entry<ShingleType, Map<Long, Shingle>> entry : entrySet())
        {
            len += entry.getKey().toString().length();
            len += 2 * (entry.getValue().size() << 1) - 1;
            for (Map.Entry<Long, Shingle> shingleInfo: entry.getValue().entrySet()) {
                len += StringBuilderable.calcExpectedStringLength(shingleInfo.getKey());
                len += StringBuilderable.calcExpectedStringLength(shingleInfo.getValue());
            }
        }
        return len;
    }

    @Override
    public void toStringBuilder(@Nonnull final StringBuilder sb) {
        sb.append(PREFIX);
        sb.append('{');
        boolean first = true;
        boolean first2;
        for (Map.Entry<ShingleType, Map<Long, Shingle>> entry : entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(entry.getKey().toString());
            sb.append("=[");
            first2 = true;
            for (Map.Entry<Long, Shingle> shingleInfo: entry.getValue().entrySet()) {
                if (first2) {
                    first2 = false;
                } else {
                    sb.append(';');
                }
                sb.append(shingleInfo.getKey());
                sb.append(':');
                StringBuilderable.toStringBuilder(sb, shingleInfo.getValue());
            }
            sb.append(']');
        }
        sb.append('}');
        sb.append(')');
    }
}

