package ru.yandex.client.so.shingler;

import java.util.Map;

// all fields types must be matched to JsonObject.Type enum values
// accepted values: Long, ULong, Integer, Short, Byte, String, Boolean, Double
// Map (for predefined fields only)
public enum UrlFieldSet implements FieldSet {
    COUNTERS {
        @Override
        public Map<String, String> fields() {
            return Map.of(
                "shingle", "ULong",
                "date", "Integer",
                "create_date", "Integer",
                "ham", "ULong",
                "spam", "ULong",
                "complaint_ham", "Long",
                "complaint_spam", "Long");
        }
    },
    RESOLVER {
        @Override
        public Map<String, String> fields() {
            return Map.of(
                "url", "String",
                "resolved", "String");
        }
    },
    MALWARE {
        @Override
        public Map<String, String> fields() {
            return Map.of("value", "ULong");
        }
    },
    DNS {
        @Override
        public Map<String, String> fields() {
            return Map.of(
                "host", "String",
                "alias", "String");
        }
    },
    CURRENT {
        @Override
        public Map<String, String> fields() {
            return Map.of("day_from_millennium", "Integer");
        }
    }
}
