package ru.yandex.client.so.shingler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

public enum UrlScheme implements Scheme {
    TODAY(SchemeType.DB, UrlFieldSet.COUNTERS, "shingle", "date"),
    HISTORY(SchemeType.DB, UrlFieldSet.COUNTERS, "shingle"),
    RESOLVE(SchemeType.SHORT_URL_RESOLVER, UrlFieldSet.RESOLVER),
    MALWARE(SchemeType.TAGS_INFO, UrlFieldSet.MALWARE),
    DNS(SchemeType.DNS, UrlFieldSet.DNS),
    CURRENT(SchemeType.CURRENT_PERIOD, UrlFieldSet.CURRENT);

    private static final Map<String, Set<UrlScheme>> fieldToScheme = new HashMap<>();

    private final SchemeType schemeType;
    private final UrlFieldSet fieldSet;
    @SuppressWarnings("ImmutableEnumChecker")
    private final Set<String> keyFields;
    @SuppressWarnings("ImmutableEnumChecker")
    private final Map<String, ?> predefinedFields;

    static {
        for (UrlScheme scheme : UrlScheme.values()) {
            for (Map.Entry<String, String> entry : scheme.fields().entrySet()) {
                fieldToScheme.computeIfAbsent(entry.getKey(), x -> new HashSet<>()).add(scheme);
            }
        }
    }

    UrlScheme(final SchemeType schemeType, final UrlFieldSet fieldSet, final String... keyFields) {
        this.schemeType = schemeType;
        this.fieldSet = fieldSet;
        this.keyFields = Set.of(keyFields);
        predefinedFields = null;
    }

    @SuppressWarnings("unused")
    UrlScheme(
        final SchemeType schemeType,
        final UrlFieldSet fieldSet,
        final Map<String, ?> predefinedFields,
        final String... keyFields)
    {
        this.schemeType = schemeType;
        this.fieldSet = fieldSet;
        this.keyFields = Set.of(keyFields);
        this.predefinedFields = Map.copyOf(predefinedFields);
    }

    @Override
    public SchemeType schemeType() {
        return schemeType;
    }

    @Override
    public UrlFieldSet fieldSet() {
        return fieldSet;
    }

    @Override
    public Map<String, String> fields() {
        return fieldSet.fields();
    }

    @Override
    public Map<String, ?> predefinedFields() {
        return predefinedFields;
    }

    @Override
    public Set<String> keyFields() {
        return keyFields;
    }

    @Override
    public Scheme fromName(String name) {
        return UrlScheme.valueOf(name);
    }

    @Nonnull
    public static Set<UrlScheme> schemesFromField(final String field) throws RuntimeException {
        Set<UrlScheme> schemes = fieldToScheme.get(field);
        if (schemes == null) {
            throw new NullPointerException("UrlScheme.schemesFromField returns null for field '" + field + "'");
        }
        return schemes;
    }

    @Override
    public String shingleField() {
        return "shingle";
    }
}
