package ru.yandex.client.so.shingler;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.Nonnull;

import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;

public class UrlShingleInfo extends EnumMap<UrlScheme, Map<String, List<Object>>>
    implements GeneralShingleInfo<UrlScheme>
{
    private static final long serialVersionUID = 0L;

    public UrlShingleInfo() {
        super(UrlScheme.class);
    }

    public UrlShingleInfo(@Nonnull final Map<UrlScheme, List<JsonMap>> jsonInfo)
        throws ShingleException
    {
        super(UrlScheme.class);
        loadInfo(jsonInfo);
    }

    public UrlShingleInfo(@Nonnull final UrlScheme scheme, @Nonnull final Map<String, Object> counters)
        throws ShingleException
    {
        super(UrlScheme.class);
        loadSchemeCounters(scheme, counters);
    }

    public UrlShingleInfo(@Nonnull final Set<UrlScheme> schemes, @Nonnull final Map<String, Object> counters)
        throws ShingleException
    {
        super(UrlScheme.class);
        for (final UrlScheme scheme : schemes) {
            loadSchemeCounters(scheme, counters);
        }
    }

    public UrlShingleInfo(@Nonnull final UrlScheme scheme, @Nonnull List<JsonMap> jsonCountersList)
        throws ShingleException
    {
        super(UrlScheme.class);
        loadSchemeCounters(scheme, jsonCountersList);
    }

    public UrlShingleInfo(@Nonnull final UrlScheme scheme, @Nonnull JsonList jsonCountersList)
        throws ShingleException, JsonBadCastException
    {
        super(UrlScheme.class);
        loadSchemeCounters(scheme, jsonCountersList);
    }

    public UrlShingleInfo(@Nonnull final UrlScheme scheme, @Nonnull JsonMap jsonCounters)
        throws ShingleException
    {
        super(UrlScheme.class);
        loadSchemeCounters(scheme, jsonCounters);
    }

    public UrlShingleInfo(
        @Nonnull final UrlScheme scheme,
        @Nonnull final String counter,
        final long shingle)
        throws ShingleException
    {
        super(UrlScheme.class);
        setSchemeCounter(scheme, counter, shingle);
    }

    public UrlShingleInfo(final GeneralShingleInfo<UrlScheme> shingleInfo) throws ShingleException {
        super(UrlScheme.class);
        addInfo(shingleInfo);
    }

    @Override
    public UrlShingleInfo copy() {
        try {
            return new UrlShingleInfo(this);
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean containsKey(UrlScheme scheme) {
        return super.containsKey(scheme);
    }

    @Override
    public Map<String, List<Object>> get(UrlScheme scheme) {
        return super.get(scheme);
    }

    @Override
    public Map<String, List<Object>> remove(UrlScheme scheme) {
        return super.remove(scheme);
    }

    @Override
    public Map<String, List<Object>> computeIfAbsent(
        UrlScheme scheme,
        Function<UrlScheme, Map<String, List<Object>>> mappingFunction)
    {
        return super.computeIfAbsent(scheme, mappingFunction);
    }

    @Nonnull
    @Override
    public Set<UrlScheme> keySet() {
        return super.keySet();
    }

    @Nonnull
    @Override
    public Set<Map.Entry<UrlScheme, Map<String, List<Object>>>> entrySet() {
        return super.entrySet();
    }

    @Nonnull
    @Override
    public String name() {
        return "Url";
    }
}
