package ru.yandex.client.so.shingler;

import javax.annotation.Nonnull;

import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class UrlShinglerClient extends GeneralShinglerClient<UrlScheme>
{
    public UrlShinglerClient(
        @Nonnull final SharedConnectingIOReactor reactor,
        @Nonnull final ImmutableHttpHostConfig config)
    {
        super(reactor, config);
    }

    protected UrlShinglerClient(
        @Nonnull final CloseableHttpAsyncClient client,
        @Nonnull final UrlShinglerClient sample)
    {
        super(client, sample);
    }

    @Override
    public UrlShinglerClient adjust(@Nonnull final CloseableHttpAsyncClient client) {
        return new UrlShinglerClient(client, this);
    }

    @Override
    protected GeneralShingles<UrlScheme> emptyResult() {
        return UrlShingles.EMPTY;
    }

    @Override
    protected GeneralShingles<UrlScheme> createShingles(@Nonnull final JsonObject jsonObject)
        throws JsonException, ShingleException
    {
        return new UrlShingles(jsonObject);
    }

    protected static String name() {
        return "Url";
    }
}
