package ru.yandex.client.so.shingler;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class UrlShingles extends GeneralShingles<UrlScheme>
{
    public static final UrlShingles EMPTY = new UrlShingles();

    private static final long serialVersionUID = 0L;
    private static final String NAME = "Url";

    public UrlShingles() {
        super();
    }

    public UrlShingles(@Nonnull final JsonObject jsonResponse) throws JsonException, ShingleException
    {
        super(jsonResponse);
    }

    public UrlShingles(@Nonnull final Map<UrlScheme, List<JsonMap>> jsonInfo)
        throws JsonException, ShingleException
    {
        super(jsonInfo);
    }

    public UrlShingles(@Nonnull final Set<UrlScheme> schemes, @Nonnull final Map<String, Object> counters)
        throws ShingleException
    {
        super(schemes, counters);
    }

    public UrlShingles(@Nonnull final Set<UrlScheme> schemes, @Nonnull final List<Map<String, Object>> countersList)
        throws ShingleException
    {
        super(schemes, countersList);
    }

    public UrlShingles(@Nonnull final UrlScheme scheme, @Nonnull final List<JsonMap> jsonCountersList)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCountersList);
    }

    public UrlShingles(@Nonnull final UrlScheme scheme, @Nonnull final JsonList jsonCountersList)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCountersList);
    }

    public UrlShingles(@Nonnull final JsonList jsonCountersList, @Nonnull final Set<UrlScheme> schemes)
        throws JsonException, ShingleException
    {
        super(jsonCountersList, schemes);
    }

    public UrlShingles(@Nonnull final UrlScheme scheme, @Nonnull final JsonMap jsonCounters)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCounters);
    }

    public UrlShingles(@Nonnull final GeneralShingles<UrlScheme> shinglesInfo) throws ShingleException {
        super(shinglesInfo);
    }

    public UrlShingles(@Nonnull final Shingles shingles) throws ShingleException {
        super(shingles, UrlScheme.schemesFromField(UrlScheme.TODAY.shingleField()));
    }

    @Override
    public GeneralShingles<UrlScheme> getEmpty() {
        return EMPTY;
    }

    @Override
    protected GeneralShingleInfo<UrlScheme> createShingleInfo() {
        return new UrlShingleInfo();
    }

    @Override
    protected GeneralShingleInfo<UrlScheme> createShingleInfo(final Map<UrlScheme, List<JsonMap>> jsonInfo)
        throws ShingleException
    {
        return new UrlShingleInfo(jsonInfo);
    }

    @Override
    protected GeneralShingleInfo<UrlScheme> createShingleInfo(
        @Nonnull final UrlScheme scheme,
        @Nonnull List<JsonMap> jsonCountersList)
        throws ShingleException
    {
        return new UrlShingleInfo(scheme, jsonCountersList);
    }

    @Override
    protected GeneralShingleInfo<UrlScheme> createShingleInfo(
        final UrlScheme scheme,
        final Map<String, Object> counters)
        throws ShingleException
    {
        return new UrlShingleInfo(scheme, counters);
    }

    @Override
    protected GeneralShingleInfo<UrlScheme> createShingleInfo(
        final Set<UrlScheme> schemes,
        final Map<String, Object> counters)
        throws ShingleException
    {
        return new UrlShingleInfo(schemes, counters);
    }

    @Override
    protected GeneralShingleInfo<UrlScheme> createShingleInfo(
        @Nonnull final UrlScheme scheme,
        @Nonnull final JsonList jsonCountersList)
        throws ShingleException, JsonBadCastException
    {
        return new UrlShingleInfo(scheme, jsonCountersList);
    }

    @Override
    protected GeneralShingleInfo<UrlScheme> createShingleInfo(
        @Nonnull final UrlScheme scheme,
        @Nonnull final JsonMap jsonCounters)
        throws ShingleException, JsonException
    {
        return new UrlShingleInfo(scheme, jsonCounters);
    }

    @Override
    protected GeneralShingleInfo<UrlScheme> createShingleInfo(
        @Nonnull final UrlScheme scheme,
        final long shingle)
        throws ShingleException
    {
        return new UrlShingleInfo(scheme, scheme.shingleField(), shingle);
    }

    @Override
    protected GeneralShingleInfo<UrlScheme> createShingleInfo(
        @Nonnull final GeneralShingleInfo<UrlScheme> shingleInfo)
        throws ShingleException
    {
        return new UrlShingleInfo(shingleInfo);
    }

    @Override
    protected UrlScheme schemeFromName(final String schemeName) {
        return UrlScheme.valueOf(schemeName);
    }

    @Override
    public String name() {
        return NAME;
    }
}
