package ru.yandex.client.so.shingler.config;

import java.util.Locale;

import ru.yandex.http.config.AbstractHttpHostConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.EnumParser;

public abstract class AbstractShinglerClientConfigBuilder<T extends AbstractShinglerClientConfigBuilder<T>>
    extends AbstractHttpHostConfigBuilder<T> implements ShinglerClientConfig
{
    private static final String SECTION = "shingler";
    private ShinglerType shinglerType;

    protected AbstractShinglerClientConfigBuilder(final ShinglerClientConfig config) {
        super(config);
        this.shinglerType = config.type();
    }

    protected AbstractShinglerClientConfigBuilder(final IniConfig config, final ShinglerClientConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        String prefix = config.prefix();
        if (prefix.startsWith(SECTION + '.')) {
            prefix = prefix.substring(SECTION.length() + 1);
        }
        if (prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.indexOf('.'));
        }
        try {
            shinglerType = ShinglerType.valueOf(prefix.replace('-', '_').toUpperCase(Locale.ROOT));
        } catch (IllegalArgumentException e) {
            EnumParser<ShinglerType> parser = new EnumParser<>(ShinglerType.class);
            shinglerType = config.get("type", null, parser);
        }
        if (shinglerType == null) {
            throw new ConfigException("Unable to parse shingler's type for section '" + prefix + "'");
        }
    }

    protected AbstractShinglerClientConfigBuilder(final IniConfig config, final ShinglerType shinglerType)
        throws ConfigException
    {
        super(config, ShinglerClientConfigDefaults.fromType(shinglerType));
        this.shinglerType = shinglerType;
    }

    protected AbstractShinglerClientConfigBuilder(final HttpHostConfig config, final ShinglerType shinglerType)
        throws ConfigException
    {
        super(config);
        this.shinglerType = shinglerType;
    }

    @Override
    public ShinglerType type() {
        return shinglerType;
    }

    public T type(final ShinglerType shinglerType) {
        this.shinglerType = shinglerType;
        return self();
    }

    public void copyTo(final AbstractShinglerClientConfigBuilder<?> other) {
        copyTo((AbstractHttpHostConfigBuilder<?>) other);
        other.type(type());
    }
}
