package ru.yandex.client.so.shingler.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.EnumParser;

public abstract class AbstractShinglerClientsConfigBuilder<T extends AbstractShinglerClientsConfigBuilder<T>>
    implements ShinglerClientsConfig
{
    public static final String SECTION = "shingler";

    private Map<ShinglerType, ShinglerClientConfig> shinglerClientsConfig;

    protected AbstractShinglerClientsConfigBuilder() {
        this(ShinglerClientsConfigDefaults.EMPTY);
    }

    protected AbstractShinglerClientsConfigBuilder(final ShinglerClientsConfig config) {
        shinglerClientsConfig = new HashMap<>(config.shinglerClientsConfig());
    }

    protected AbstractShinglerClientsConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, ShinglerClientsConfigDefaults.EMPTY);
    }

    protected AbstractShinglerClientsConfigBuilder(final IniConfig config, final ShinglerClientsConfig defaults)
        throws ConfigException
    {
        shinglerClientsConfig = loadShinglers(config, defaults);
    }

    public static Map<ShinglerType, ShinglerClientConfig> loadShinglers(
        final IniConfig section, final ShinglerClientsConfig defaults)
        throws ConfigException
    {
        Map<ShinglerType, ShinglerClientConfig> shinglerConfigs = new HashMap<>(defaults.shinglerClientsConfig());
        for (Map.Entry<String, IniConfig> entry : section.sections().entrySet()) {
            String subsection = entry.getKey();
            IniConfig subsectionConfig = entry.getValue();
            ShinglerType subsectionType;
            try {
                subsectionType = ShinglerType.valueOf(subsection.toUpperCase(Locale.ROOT).replace('-', '_'));
            } catch (IllegalArgumentException e) {
                EnumParser<ShinglerType> parser = new EnumParser<>(ShinglerType.class);
                subsectionType = subsectionConfig.get("type", null, parser);
            }
            if (subsectionType == null) {
                throw new ConfigException("Unable to parse shingler's type for subsection '" + subsection + "'");
            }
            shinglerConfigs.put(subsectionType, subsectionType.createConfig(subsectionConfig));
        }
        return shinglerConfigs;
    }

    @Override
    public Map<ShinglerType, ShinglerClientConfig> shinglerClientsConfig() {
        return shinglerClientsConfig;
    }

    public T shinglerClientsConfig(final Map<ShinglerType, ? extends ShinglerClientConfig> shinglersConfig)
    {
        this.shinglerClientsConfig = new HashMap<>(shinglersConfig);
        return self();
    }

    public T shinglerClientConfig(final ShinglerType shinglerType, final ShinglerClientConfig shinglerConfig)
    {
        shinglerClientsConfig.put(shinglerType, shinglerConfig);
        return self();
    }

    public T shinglerClientConfig(final ShinglerType shinglerType, final HttpHostConfig shinglerConfig)
        throws ConfigException
    {
        shinglerClientsConfig.put(shinglerType, new ShinglerClientConfigBuilder(shinglerConfig, shinglerType));
        return self();
    }

    public ImmutableShinglerClientsConfig build() throws ConfigException {
        return new ImmutableShinglerClientsConfig(this);
    }

    protected abstract T self();
}
