package ru.yandex.client.so.shingler.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableShinglerClientConfig extends ImmutableHttpHostConfig implements ShinglerClientConfig {
    private final ShinglerType shinglerType;

    public ImmutableShinglerClientConfig(final ShinglerClientConfig config) throws ConfigException {
        super(config);
        shinglerType = config.type();
    }

    @Override
    public ShinglerType type() {
        return shinglerType;
    }
}
