package ru.yandex.client.so.shingler.config;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.client.so.shingler.AbstractShinglerClient;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.parser.config.ConfigException;

public class ImmutableShinglerClientsConfig implements ShinglerClientsConfig {
    private final Map<ShinglerType, ? extends ShinglerClientConfig> shinglerClientsConfig;

    public ImmutableShinglerClientsConfig(final ShinglerClientsConfig config)
    {
        shinglerClientsConfig = config.shinglerClientsConfig();
    }

    @Override
    public Map<ShinglerType, ? extends ShinglerClientConfig> shinglerClientsConfig() {
        return shinglerClientsConfig;
    }

    public ShinglerClientConfig shinglerClientConfig(final ShinglerType shinglerType) {
        return shinglerClientsConfig.get(shinglerType);
    }

    public Map<ShinglerType, AbstractShinglerClient<?, ?>> prepareShinglerClients(final HttpProxy<?> server)
        throws ConfigException
    {
        final Map<ShinglerType, AbstractShinglerClient<?, ?>> shinglerClients = new HashMap<>();
        for (Map.Entry<ShinglerType, ? extends ShinglerClientConfig> entry : shinglerClientsConfig.entrySet()) {
            ShinglerType shinglerType = entry.getKey();
            ImmutableShinglerClientConfig config =
                new ShinglerClientConfigBuilder(entry.getValue(), shinglerType)
                    .build();
            AbstractShinglerClient<?, ?> client = (AbstractShinglerClient<?, ?>) shinglerType
                .createClient(server, config)
                .registerClient(server, entry.getKey().name(), config);
            shinglerClients.put(shinglerType, client);
        }
        return shinglerClients;
    }
}
