package ru.yandex.client.so.shingler.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class ShinglerClientConfigBuilder extends AbstractShinglerClientConfigBuilder<ShinglerClientConfigBuilder>
{
    public ShinglerClientConfigBuilder() {
        super(ShinglerClientConfigDefaults.EMPTY);
    }

    public ShinglerClientConfigBuilder(final ShinglerClientConfig config) {
        super(config);
    }

    public ShinglerClientConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, ShinglerClientConfigDefaults.EMPTY);
    }

    public ShinglerClientConfigBuilder(final IniConfig config, final ShinglerClientConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ShinglerClientConfigBuilder(final IniConfig config, final ShinglerType shinglerType)
        throws ConfigException
    {
        super(config, shinglerType);
    }

    public ShinglerClientConfigBuilder(final HttpHostConfig config, final ShinglerType shinglerType)
        throws ConfigException
    {
        super(config, shinglerType);
    }

    @Override
    public ShinglerClientConfigBuilder self() {
        return this;
    }

    ImmutableShinglerClientConfig build() throws ConfigException {
        return new ImmutableShinglerClientConfig(this);
    }
}
