package ru.yandex.client.so.shingler.config;

import org.apache.http.HttpHost;

import ru.yandex.http.config.HttpHostConfigDefaults;

public class ShinglerClientConfigDefaults extends HttpHostConfigDefaults implements ShinglerClientConfig
{
    public static final ShinglerClientConfigDefaults EMPTY = new ShinglerClientConfigDefaults();
    public static final ShinglerClientConfigDefaults ACTIVITY = new ShinglerClientConfigDefaults(ShinglerType.ACTIVITY);
    public static final ShinglerClientConfigDefaults MASS_IN = new ShinglerClientConfigDefaults(ShinglerType.MASS_IN);
    public static final ShinglerClientConfigDefaults MASS_OUT = new ShinglerClientConfigDefaults(ShinglerType.MASS_OUT);
    public static final ShinglerClientConfigDefaults COMPL = new ShinglerClientConfigDefaults(ShinglerType.COMPL);
    public static final ShinglerClientConfigDefaults DICT = new ShinglerClientConfigDefaults(ShinglerType.DICT);
    public static final ShinglerClientConfigDefaults FREEMAIL = new ShinglerClientConfigDefaults(ShinglerType.FREEMAIL);
    public static final ShinglerClientConfigDefaults SENDER = new ShinglerClientConfigDefaults(ShinglerType.SENDER);
    public static final ShinglerClientConfigDefaults URL = new ShinglerClientConfigDefaults(ShinglerType.URL);

    private final ShinglerType shinglerType;
    private final HttpHost host;

    protected ShinglerClientConfigDefaults() {
        shinglerType = null;
        host = HttpHostConfigDefaults.INSTANCE.host();
    }

    protected ShinglerClientConfigDefaults(final ShinglerType shinglerType) {
        this.shinglerType = shinglerType;
        host = HttpHostConfigDefaults.INSTANCE.host();
    }

    protected static ShinglerClientConfigDefaults fromType(final ShinglerType shinglerType) {
        switch (shinglerType) {
            case ACTIVITY:
                return ACTIVITY;
            case MASS_IN:
                return MASS_IN;
            case MASS_OUT:
                return MASS_OUT;
            case COMPL:
                return COMPL;
            case DICT:
                return DICT;
            case FREEMAIL:
                return FREEMAIL;
            case SENDER:
                return SENDER;
            case URL:
                return URL;
            default:
                return EMPTY;
        }
    }

    @Override
    public ShinglerType type() {
        return shinglerType;
    }

    @Override
    public HttpHost host() {
        return host;
    }

    @Override
    public int connections() {
        return 10;
    }
}
