package ru.yandex.client.so.shingler.config;

import java.util.HashMap;
import java.util.Map;

public class ShinglerClientsConfigDefaults implements ShinglerClientsConfig {
    public static final ShinglerClientsConfigDefaults INSTANCE =
        new ShinglerClientsConfigDefaults(Map.of(
            ShinglerType.ACTIVITY, ShinglerClientConfigDefaults.ACTIVITY,
            ShinglerType.MASS_IN, ShinglerClientConfigDefaults.MASS_IN,
            ShinglerType.MASS_OUT, ShinglerClientConfigDefaults.MASS_OUT,
            ShinglerType.COMPL, ShinglerClientConfigDefaults.COMPL,
            ShinglerType.DICT, ShinglerClientConfigDefaults.DICT,
            ShinglerType.FREEMAIL, ShinglerClientConfigDefaults.FREEMAIL,
            ShinglerType.SENDER, ShinglerClientConfigDefaults.SENDER,
            ShinglerType.URL, ShinglerClientConfigDefaults.URL
        ));
    public static final ShinglerClientsConfigDefaults EMPTY = new ShinglerClientsConfigDefaults();

    private final Map<ShinglerType, ShinglerClientConfig> shinglerConfigs = new HashMap<>();

    protected ShinglerClientsConfigDefaults() {
    }

    protected ShinglerClientsConfigDefaults(final Map<ShinglerType, ? extends ShinglerClientConfig> shinglerConfigs) {
        if (shinglerConfigs != null) {
            this.shinglerConfigs.putAll(shinglerConfigs);
        }
    }

    @Override
    public Map<ShinglerType, ? extends ShinglerClientConfig> shinglerClientsConfig() {
        return shinglerConfigs;
    }
}
