package ru.yandex.client.so.shingler.config;

import javax.annotation.Nonnull;

import ru.yandex.client.so.shingler.AbstractShinglerClient;
import ru.yandex.client.so.shingler.ActivityScheme;
import ru.yandex.client.so.shingler.ActivityShinglerClient;
import ru.yandex.client.so.shingler.ComplScheme;
import ru.yandex.client.so.shingler.ComplShinglerClient;
import ru.yandex.client.so.shingler.DictShinglerClient;
import ru.yandex.client.so.shingler.DictShinglerResult;
import ru.yandex.client.so.shingler.FreemailScheme;
import ru.yandex.client.so.shingler.FreemailShinglerClient;
import ru.yandex.client.so.shingler.GeneralShinglerClient;
import ru.yandex.client.so.shingler.GeneralShingles;
import ru.yandex.client.so.shingler.MassShinglerClient;
import ru.yandex.client.so.shingler.MassShinglerResult;
import ru.yandex.client.so.shingler.SenderScheme;
import ru.yandex.client.so.shingler.SenderShinglerClient;
import ru.yandex.client.so.shingler.UrlScheme;
import ru.yandex.client.so.shingler.UrlShinglerClient;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum ShinglerType {
    ACTIVITY {      // Activity Shingler
        @Override
        public AbstractShinglerClient<GeneralShinglerClient<ActivityScheme>, GeneralShingles<ActivityScheme>>
        createClient(
            final SharedConnectingIOReactor reactor,
            final ImmutableHttpHostConfig config)
        {
            return new ActivityShinglerClient(reactor, config);
        }

        @Override
        public ShinglerDataType dataType() {
            return ShinglerDataType.JSON;
        }
    },
    MASS_IN {      // Mass Shingler for SO IN
        @Override
        public AbstractShinglerClient<MassShinglerClient, MassShinglerResult> createClient(
            final SharedConnectingIOReactor reactor,
            final ImmutableHttpHostConfig config)
        {
            return new MassShinglerClient(reactor, config);
        }

        @Override
        public ShinglerDataType dataType() {
            return ShinglerDataType.TEXT;
        }
    },
    MASS_OUT {      // Mass Shingler got SO OUT
        @Override
        public AbstractShinglerClient<MassShinglerClient, MassShinglerResult> createClient(
            final SharedConnectingIOReactor reactor,
            final ImmutableHttpHostConfig config)
        {
            return new MassShinglerClient(reactor, config);
        }

        @Override
        public ShinglerDataType dataType() {
            return ShinglerDataType.TEXT;
        }
    },
    COMPL {     // Compl-Shingler
        @Override
        public AbstractShinglerClient<GeneralShinglerClient<ComplScheme>, GeneralShingles<ComplScheme>>
        createClient(
            final SharedConnectingIOReactor reactor,
            final ImmutableHttpHostConfig config)
        {
            return new ComplShinglerClient(reactor, config);
        }

        @Override
        public ShinglerDataType dataType() {
            return ShinglerDataType.JSON;
        }
    },
    DICT {      // Dictionary Shingler
        @Override
        public AbstractShinglerClient<DictShinglerClient, DictShinglerResult> createClient(
            final SharedConnectingIOReactor reactor,
            final ImmutableHttpHostConfig config)
        {
            return new DictShinglerClient(reactor, config);
        }

        @Override
        public ShinglerDataType dataType() {
            return ShinglerDataType.TEXT;
        }
    },
    FREEMAIL {  // Freemail Shingler
        @Override
        public AbstractShinglerClient<GeneralShinglerClient<FreemailScheme>, GeneralShingles<FreemailScheme>>
        createClient(
            @Nonnull final SharedConnectingIOReactor reactor,
            @Nonnull final ImmutableHttpHostConfig config)
        {
            return new FreemailShinglerClient(reactor, config);
        }

        @Override
        public ShinglerDataType dataType() {
            return ShinglerDataType.JSON;
        }
    },
    SENDER {   // Senders reputations
        @Override
        public AbstractShinglerClient<GeneralShinglerClient<SenderScheme>, GeneralShingles<SenderScheme>>
        createClient(
            @Nonnull final SharedConnectingIOReactor reactor,
            @Nonnull final ImmutableHttpHostConfig config)
        {
            return new SenderShinglerClient(reactor, config);
        }

        @Override
        public ShinglerDataType dataType() {
            return ShinglerDataType.JSON;
        }
    },
    URL {       // Url-Shingler
        @Override
        public AbstractShinglerClient<GeneralShinglerClient<UrlScheme>, GeneralShingles<UrlScheme>>
        createClient(
            @Nonnull final SharedConnectingIOReactor reactor,
            @Nonnull final ImmutableHttpHostConfig config)
        {
            return new UrlShinglerClient(reactor, config);
        }

        @Override
        public ShinglerDataType dataType() {
            return ShinglerDataType.JSON;
        }
    };

    public abstract ShinglerDataType dataType();

    public abstract AbstractShinglerClient<? extends AbstractAsyncClient<?>, ?> createClient(
        final SharedConnectingIOReactor reactor,
        final ImmutableHttpHostConfig config);

    public AbstractShinglerClient<? extends AbstractAsyncClient<?>, ?> createClient(
        final HttpProxy<?> server,
        final ImmutableHttpHostConfig config)
    {
        return createClient(server.reactor(), config);
    }

    public AbstractShinglerClient<? extends AbstractAsyncClient<?>, ?> createClient(@Nonnull final HttpProxy<?> server, @Nonnull final IniConfig config)
        throws ConfigException
    {
        return createClient(server, new ShinglerClientConfigBuilder(config, this).build());
    }

    public ShinglerClientConfig createConfig(@Nonnull final IniConfig config) throws ConfigException
    {
        return new ShinglerClientConfigBuilder(config, this).build();
    }

    public static ImmutableShinglerClientConfig createConfig(@Nonnull final ShinglerClientConfig config)
        throws ConfigException
    {
        return new ShinglerClientConfigBuilder(config).build();
    }
}
