package ru.yandex.mail.so.factors;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.mail.so.factors.types.SoFactorType;

public class ChainedSoFactorFieldAccessor
    extends AbstractStringBuilderable
    implements SoFactorFieldAccessor
{
    private final SoFactorFieldAccessor first;
    private final SoFactorFieldAccessor second;

    public ChainedSoFactorFieldAccessor(
        final SoFactorFieldAccessor first,
        final SoFactorFieldAccessor second)
    {
        this.first = first;
        this.second = second;
    }

    @Override
    public Object extractField(
        final Object value,
        final FactorsAccessViolationHandler accessViolationHandler)
    {
        Object intermediate =
            first.extractField(value, accessViolationHandler);
        if (intermediate == null) {
            return null;
        } else {
            return second.extractField(intermediate, accessViolationHandler);
        }
    }

    @Override
    public SoFactorType<?> variableType() {
        return first.variableType();
    }

    @Override
    public SoFactorType<?> fieldType() {
        return second.fieldType();
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        first.toStringBuilder(sb);
        second.toStringBuilder(sb);
    }
}

