package ru.yandex.mail.so.factors;

import ru.yandex.mail.so.factors.types.SoFactorType;

public class ConcatSoFunctionInputs implements SoFunctionInputs {
    private final SoFunctionInputs first;
    private final SoFunctionInputs second;
    private final int firstSize;
    private final int size;

    public ConcatSoFunctionInputs(
        final SoFunctionInputs first,
        final SoFunctionInputs second)
    {
        this.first = first;
        this.second = second;
        firstSize = first.size();
        size = firstSize + second.size();
    }

    @Override
    public FactorsAccessViolationHandler accessViolationHandler() {
        return first.accessViolationHandler();
    }

    @Override
    public SoFactor<?> get(int pos) {
        if (pos < firstSize) {
            return first.get(pos);
        } else {
            return second.get(pos - firstSize);
        }
    }

    @Override
    public <T> T get(int pos, SoFactorType<T> type) {
        if (pos < firstSize) {
            return first.get(pos, type);
        } else {
            return second.get(pos - firstSize, type);
        }
    }

    @Override
    public int size() {
        return size;
    }
}

