package ru.yandex.mail.so.factors;

import java.util.concurrent.atomic.LongAdder;

import ru.yandex.mail.so.factors.types.SoFactorType;

public interface FactorsAccessViolationHandler {
    LongAdder violationsCounter();

    void handleFactorOutOfBounds(int id, int size);

    void handleFactorOutOfBounds(
        int id,
        int size,
        SoFactorType<?> expectedType);

    void handleFactorTypeMismatch(
        int id,
        SoFactorType<?> expectedType,
        SoFactor<?> actualFactor);

    void handleBadFieldAccessorFieldType(
        int id,
        SoFactor<?> factor,
        SoFactorFieldAccessor fieldAccessor,
        Object value);

    void handleFieldConversionFailure(String message);

    void handleFieldConversionFailure(
        String message,
        Exception e);
}

