package ru.yandex.mail.so.factors;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.mail.so.factors.types.SoFactorType;

public class IdentitySoFactorFieldAccessor
    extends AbstractStringBuilderable
    implements SoFactorFieldAccessor
{
    private final SoFactorType<?> type;

    public IdentitySoFactorFieldAccessor(final SoFactorType<?> type) {
        this.type = type;
    }

    @Override
    public Object extractField(
        final Object value,
        final FactorsAccessViolationHandler accessViolationHandler)
    {
        return value;
    }

    @Override
    public SoFactorType<?> variableType() {
        return type;
    }

    @Override
    public SoFactorType<?> fieldType() {
        return type;
    }

    @Override
    public SoFactorFieldAccessor andThen(final SoFactorFieldAccessor next) {
        return next;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
    }
}

