package ru.yandex.mail.so.factors;

import ru.yandex.mail.so.factors.types.SoFactorType;

public class OverrideTypeSoFactorFieldAccessor
    implements SoFactorFieldAccessor
{
    private final SoFactorFieldAccessor fieldAccessor;
    private final SoFactorType<?> variableType;

    public OverrideTypeSoFactorFieldAccessor(
        final SoFactorFieldAccessor fieldAccessor,
        final SoFactorType<?> variableType)
    {
        this.fieldAccessor = fieldAccessor;
        this.variableType = variableType;
    }

    @Override
    public Object extractField(
        final Object value,
        final FactorsAccessViolationHandler accessViolationHandler)
    {
        return fieldAccessor.extractField(value, accessViolationHandler);
    }

    @Override
    public SoFactorType<?> variableType() {
        return variableType;
    }

    @Override
    public SoFactorType<?> fieldType() {
        return fieldAccessor.fieldType();
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        fieldAccessor.toStringBuilder(sb);
    }

    @Override
    public String toString() {
        return fieldAccessor.toString();
    }
}

