package ru.yandex.mail.so.factors;

import java.util.List;

import ru.yandex.mail.so.factors.types.SoFactorType;

public class RemappingSoFunctionInputs implements SoFunctionInputs {
    private final FactorsAccessViolationHandler accessViolationHandler;
    private final SoFunctionInputs input;
    private final int[] indexesRemapping;
    private final List<SoFactorFieldAccessor> fieldsAccessors;

    public RemappingSoFunctionInputs(
        final FactorsAccessViolationHandler accessViolationHandler,
        final SoFunctionInputs input,
        final Remapping remapping)
    {
        this.accessViolationHandler = accessViolationHandler;
        this.input = input;
        indexesRemapping = remapping.indexesRemapping();
        fieldsAccessors = remapping.fieldsAccessors();
    }

    @Override
    public FactorsAccessViolationHandler accessViolationHandler() {
        return accessViolationHandler;
    }

    @Override
    public SoFactor<?> get(final int pos) {
        if (pos < 0 || pos >= indexesRemapping.length) {
            accessViolationHandler.handleFactorOutOfBounds(
                pos,
                indexesRemapping.length);
            return null;
        }
        SoFactor<?> factor = input.get(indexesRemapping[pos]);
        if (factor == null) {
            return null;
        } else {
            SoFactorFieldAccessor fieldAccessor = fieldsAccessors.get(pos);
            if (fieldAccessor == null) {
                return factor;
            } else if (fieldAccessor.variableType() == factor.type()) {
                Object value =
                    fieldAccessor.extractField(
                        factor.value(),
                        accessViolationHandler);
                if (value == null) {
                    return null;
                } else {
                    SoFactor<?> outputFactor =
                        fieldAccessor.fieldType().tryCreateFactor(value);
                    if (outputFactor == null) {
                        accessViolationHandler.handleBadFieldAccessorFieldType(
                            pos,
                            factor,
                            fieldAccessor,
                            value);
                    }
                    return outputFactor;
                }
            } else {
                accessViolationHandler.handleFactorTypeMismatch(
                    pos,
                    fieldAccessor.variableType(),
                    factor);
                return null;
            }
        }
    }

    @Override
    public <T> T get(int pos, SoFactorType<T> type) {
        if (pos < 0 || pos >= indexesRemapping.length) {
            accessViolationHandler.handleFactorOutOfBounds(
                pos,
                indexesRemapping.length,
                type);
            return null;
        }
        SoFactorFieldAccessor fieldAccessor = fieldsAccessors.get(pos);
        if (fieldAccessor == null) {
            return input.get(indexesRemapping[pos], type);
        } else {
            Object value = input.get(
                indexesRemapping[pos],
                fieldAccessor.variableType());
            if (value == null) {
                return null;
            } else if (fieldAccessor.fieldType() == type) {
                return type.cast(
                    fieldAccessor.extractField(value, accessViolationHandler));
            } else {
                accessViolationHandler.handleFactorTypeMismatch(
                    pos,
                    fieldAccessor.fieldType(),
                    input.get(indexesRemapping[pos]));
                return null;
            }
        }
    }

    @Override
    public int size() {
        return indexesRemapping.length;
    }
}

