package ru.yandex.mail.so.factors;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.mail.so.factors.types.SoFactorType;

public class SoFactor<T> extends AbstractStringBuilderable {
    private final SoFactorType<T> type;
    private final T value;

    public SoFactor(final SoFactorType<T> type, final T value) {
        this.type = type;
        this.value = value;
    }

    public SoFactorType<T> type() {
        return type;
    }

    public T value() {
        return value;
    }

    public SoFactor<T> renameFactor(final SoFactorType<T> newType) {
        return new SoFactor<>(newType, value);
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        type.toStringBuilder(sb);
        sb.append('{');
        sb.append(value);
        sb.append('}');
    }
}

