package ru.yandex.mail.so.factors;

import ru.yandex.function.StringBuilderable;
import ru.yandex.mail.so.factors.types.SoFactorType;

public interface SoFactorFieldAccessor extends StringBuilderable {
    Object extractField(
        Object value,
        FactorsAccessViolationHandler accessViolationHandler);

    SoFactorType<?> variableType();

    SoFactorType<?> fieldType();

    // XXX: Here we should check that fieldType() == next.variableType() but
    // this is the only possible situation
    default SoFactorFieldAccessor andThen(final SoFactorFieldAccessor next) {
        return new ChainedSoFactorFieldAccessor(this, next);
    }
}

