package ru.yandex.mail.so.factors;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.mail.so.factors.types.SoFactorType;

public abstract class SoFactorFieldAccessorBase
    extends AbstractStringBuilderable
    implements SoFactorFieldAccessor
{
    private final SoFactorType<?> variableType;
    private final SoFactorType<?> fieldType;
    private final String stringValue;

    protected SoFactorFieldAccessorBase(
        final SoFactorType<?> variableType,
        final SoFactorType<?> fieldType,
        final String stringValue)
    {
        this.variableType = variableType;
        this.fieldType = fieldType;
        this.stringValue = stringValue;
    }

    @Override
    public SoFactorType<?> variableType() {
        return variableType;
    }

    @Override
    public SoFactorType<?> fieldType() {
        return fieldType;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append(stringValue);
    }
}

