package ru.yandex.mail.so.factors;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.mail.so.factors.types.SoFactorType;

public class SoFunctionArgumentInfo extends AbstractStringBuilderable {
    private final SoFactorType<?> type;
    private final String name;

    public SoFunctionArgumentInfo(
        final SoFactorType<?> type,
        final String name)
    {
        this.type = type;
        this.name = name;
    }

    public SoFactorType<?> type() {
        return type;
    }

    public String name() {
        return name;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        type.toStringBuilder(sb);
        sb.append(' ');
        sb.append(name);
    }
}

