package ru.yandex.mail.so.factors.actions;

public class Actions {
    private final IndexActions indexActions;

    public Actions() {
        indexActions = new IndexActions();
    }

    public Actions(final IndexActions indexActions) {
        this.indexActions = indexActions;
    }

    public Actions merge(final Actions actions) {
        return new Actions(indexActions.merge(actions.indexActions()));
    }

    public IndexActions indexActions() {
        return indexActions;
    }

    public static Actions merge(final Actions lhs, final Actions rhs) {
        if (lhs == null) {
            return rhs;
        } else if (rhs == null) {
            return lhs;
        } else {
            return lhs.merge(rhs);
        }
    }
}

