package ru.yandex.mail.so.factors.actions;

import java.io.IOException;

import ru.yandex.json.writer.JsonWriter;

public enum IndexActionType {
    ADD("/add?"),
    MODIFY("/modify?"),
    UPDATE("/update?"),
    UPDATE_ADD_IF_NOT_EXITS("/update?") {
        @Override
        public void additionalJsonData(final JsonWriter writer)
            throws IOException
        {
            writer.key("AddIfNotExists");
            writer.value(true);
        }
    },
    DELETE("/delete?");

    private final String uri;

    IndexActionType(final String uri) {
        this.uri = uri;
    }

    public String uri() {
        return uri;
    }

    public void additionalJsonData(final JsonWriter writer)
        throws IOException
    {
    }
}

