package ru.yandex.mail.so.factors.actions;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.json.dom.JsonList;

public class IndexActions {
    // Map from uid to action (add, modify, update) and docs for this action
    private final Map<Long, EnumMap<IndexActionType, JsonList>> uidToActions;

    public IndexActions() {
        uidToActions = Collections.emptyMap();
    }

    public IndexActions(
        final Long uid,
        final IndexActionType actionType,
        final JsonList docs)
    {
        EnumMap<IndexActionType, JsonList> actions =
            new EnumMap<>(IndexActionType.class);
        actions.put(actionType, docs);
        uidToActions = Collections.singletonMap(uid, actions);
    }

    public IndexActions(
        final Map<Long, EnumMap<IndexActionType, JsonList>> uidToActions1,
        final Map<Long, EnumMap<IndexActionType, JsonList>> uidToActions2)
    {
        int size1 = uidToActions1.size();
        if (size1 == 0) {
            uidToActions = copyAllActions(uidToActions2);
        } else {
            int size2 = uidToActions2.size();
            if (size2 == 0) {
                uidToActions = copyAllActions(uidToActions1);
            } else {
                uidToActions = copyAllActions(uidToActions1, size1 + size2);
                for (Map.Entry<Long, EnumMap<IndexActionType, JsonList>> entry
                    : uidToActions2.entrySet())
                {
                    Long uid = entry.getKey();
                    EnumMap<IndexActionType, JsonList> actions =
                        entry.getValue();
                    EnumMap<IndexActionType, JsonList> oldActions =
                        uidToActions.get(uid);
                    if (oldActions == null) {
                        uidToActions.put(uid, copyActions(actions));
                    } else  {
                        for (Map.Entry<IndexActionType, JsonList> actionEntry
                            : actions.entrySet())
                        {
                            IndexActionType actionType = actionEntry.getKey();
                            JsonList docs = actionEntry.getValue().deepCopy();
                            JsonList oldDocs = oldActions.get(actionType);
                            if (oldDocs == null) {
                                oldActions.put(actionType, docs);
                            } else {
                                oldDocs.addAll(docs);
                            }
                        }
                    }
                }
            }
        }
    }

    public static Map<Long, EnumMap<IndexActionType, JsonList>> copyAllActions(
        final Map<Long, EnumMap<IndexActionType, JsonList>> actions)
    {
        return copyAllActions(actions, actions.size());
    }

    public static Map<Long, EnumMap<IndexActionType, JsonList>> copyAllActions(
        final Map<Long, EnumMap<IndexActionType, JsonList>> actions,
        final int size)
    {
        Map<Long, EnumMap<IndexActionType, JsonList>> copy =
            new HashMap<>(size << 1);
        for (Map.Entry<Long, EnumMap<IndexActionType, JsonList>> entry
            : actions.entrySet())
        {
            copy.put(entry.getKey(), copyActions(entry.getValue()));
        }
        return copy;
    }

    private static EnumMap<IndexActionType, JsonList> copyActions(
        final EnumMap<IndexActionType, JsonList> actions)
    {
        EnumMap<IndexActionType, JsonList> copy = new EnumMap<>(actions);
        for (Map.Entry<IndexActionType, JsonList> entry: copy.entrySet()) {
            entry.setValue(entry.getValue().deepCopy());
        }
        return copy;
    }

    public IndexActions merge(final IndexActions indexActions) {
        return new IndexActions(uidToActions, indexActions.uidToActions);
    }

    public Map<Long, EnumMap<IndexActionType, JsonList>> uidToActions() {
        return uidToActions;
    }
}

