package ru.yandex.mail.so.factors.blackbox;

import java.util.function.BinaryOperator;

public class BlackboxStat {
    public static final BlackboxStat ZERO =
        new BlackboxStat(0L, 0L, 0L, 0L, 0L, 0L);

    private final long notFound;
    private final long incomplete;
    private final long empty;
    private final long errors;
    private final long success;
    private final long count;

    public BlackboxStat(
        final long notFound,
        final long incomplete,
        final long empty,
        final long errors,
        final long success)
    {
        this(notFound, incomplete, empty, errors, success, 1L);
    }

    private BlackboxStat(
        final long notFound,
        final long incomplete,
        final long empty,
        final long errors,
        final long success,
        final long count)
    {
        this.notFound = notFound;
        this.incomplete = incomplete;
        this.empty = empty;
        this.errors = errors;
        this.success = success;
        this.count = count;
    }

    public long notFound() {
        return notFound;
    }

    public long incomplete() {
        return incomplete;
    }

    public long empty() {
        return empty;
    }

    public long errors() {
        return errors;
    }

    public long success() {
        return success;
    }

    public long count() {
        return count;
    }

    public enum Accumulator implements BinaryOperator<BlackboxStat> {
        INSTANCE;

        @Override
        public BlackboxStat apply(
            final BlackboxStat lhs,
            final BlackboxStat rhs)
        {
            return new BlackboxStat(
                lhs.notFound + rhs.notFound,
                lhs.incomplete + rhs.incomplete,
                lhs.empty + rhs.empty,
                lhs.errors + rhs.errors,
                lhs.success + rhs.success,
                lhs.count + rhs.count);
        }
    }
}

