package ru.yandex.mail.so.factors.blackbox;

import java.util.function.Consumer;

import ru.yandex.concurrent.ConcurrentAccumulator;
import ru.yandex.stater.GolovanChart;
import ru.yandex.stater.GolovanChartGroup;
import ru.yandex.stater.GolovanPanel;
import ru.yandex.stater.GolovanSignal;
import ru.yandex.stater.ImmutableGolovanPanelConfig;
import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;
import ru.yandex.util.string.StringUtils;

public class BlackboxStater implements Stater {
    private final ConcurrentAccumulator<BlackboxStat> accumulator =
        new ConcurrentAccumulator<>(
            BlackboxStat.Accumulator.INSTANCE,
            BlackboxStat.ZERO);
    private final String category;
    private final String title;
    private final String prefix;

    public BlackboxStater(
        final String category,
        final String title,
        final String prefix)
    {
        this.category = category;
        this.title = title;
        this.prefix = prefix;
    }

    public Consumer<BlackboxStat> consumer() {
        return accumulator;
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        BlackboxStat stat = accumulator.get();
        statsConsumer.stat(
            StringUtils.concat(prefix, "not-found_dmmm"),
            stat.notFound());
        statsConsumer.stat(
            StringUtils.concat(prefix, "incomplete_dmmm"),
            stat.incomplete());
        statsConsumer.stat(
            StringUtils.concat(prefix, "empty_dmmm"),
            stat.empty());
        statsConsumer.stat(
            StringUtils.concat(prefix, "errors_dmmm"),
            stat.errors());
        statsConsumer.stat(
            StringUtils.concat(prefix, "success_dmmm"),
            stat.success());
        statsConsumer.stat(
            StringUtils.concat(prefix, "invocations_dmmm"),
            stat.count());
        statsConsumer.stat(
            StringUtils.concat(prefix, "total_dmmm"),
            stat.notFound()
            + stat.incomplete()
            + stat.errors()
            + stat.success());
    }

    @Override
    public void addToGolovanPanel(
        final GolovanPanel panel,
        final String statsPrefix)
    {
        String prefix = StringUtils.removeSuffix(this.prefix, '-');
        String chartsPrefix = statsPrefix + prefix;
        GolovanChartGroup group =
            new GolovanChartGroup(chartsPrefix, statsPrefix);
        ImmutableGolovanPanelConfig config = panel.config();

        GolovanChart results = new GolovanChart(
            "-results",
            " results (rps)",
            true,
            true,
            0d);
        results.addSignal(
            new GolovanSignal(
                chartsPrefix + "-errors_dmmm",
                config.tag(),
                "errors",
                "#ff3f00",
                1,
                false));
        results.addSignal(
            new GolovanSignal(
                chartsPrefix + "-empty_dmmm",
                config.tag(),
                "empty",
                "#ff0000",
                1,
                false));
        results.addSignal(
            new GolovanSignal(
                chartsPrefix + "-incomplete_dmmm",
                config.tag(),
                "incomplete",
                "#7f0000",
                1,
                false));
        results.addSignal(
            new GolovanSignal(
                chartsPrefix + "-not-found_dmmm",
                config.tag(),
                "not found",
                "#ffff00",
                1,
                false));
        results.addSignal(
            new GolovanSignal(
                chartsPrefix + "-success_dmmm",
                config.tag(),
                "success",
                "#00ff00",
                1,
                false));
        group.addChart(results);
        panel.addCharts(category, title, group);
    }
}

