package ru.yandex.mail.so.factors.blackbox;

import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.blackbox.BlackboxNotFoundException;
import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.blackbox.BlackboxUserinfoRequest;
import ru.yandex.blackbox.BlackboxUserinfos;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractor;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorFactoryContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.LongSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class BlackboxUserinfoExtractor
    extends BlackboxExtractorBase
    implements SoFactorsExtractor
{
    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(LongSoFactorType.LONG);
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(BlackboxUserinfoSoFactorType.USERINFO);

    public BlackboxUserinfoExtractor(
        final String name,
        final SoFactorsExtractorFactoryContext context,
        final IniConfig config)
        throws ConfigException
    {
        super(name, context, config);
    }

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        Long uidBoxed = inputs.get(0, LongSoFactorType.LONG);
        if (uidBoxed == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        long uid = uidBoxed.longValue();
        BlackboxClient client;
        if (BlackboxUserinfo.corp(uid)) {
            client = corpBlackboxClient;
        } else {
            client = blackboxClient;
        }
        client = client.adjust(context.httpContext());
        client.userinfo(
            adjustRequest(new BlackboxUserinfoRequest(uid)),
            context.requestsListener().createContextGeneratorFor(client),
            new Callback(callback));
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        BlackboxUserinfosExtractorFactory.INSTANCE.registerInternals(registry);
    }

    private static class Callback
        extends AbstractFilterFutureCallback<
            BlackboxUserinfos,
            List<SoFactor<?>>>
    {
        Callback(final FutureCallback<? super List<SoFactor<?>>> callback) {
            super(callback);
        }

        @Override
        public void failed(final Exception e) {
            if (e instanceof BlackboxNotFoundException) {
                callback.completed(NULL_RESULT);
            } else {
                callback.failed(e);
            }
        }

        @Override
        public void completed(final BlackboxUserinfos userinfos) {
            callback.completed(
                Collections.singletonList(
                    BlackboxUserinfoSoFactorType.USERINFO.createFactor(
                        userinfos.get(0))));
        }
    }
}

