package ru.yandex.mail.so.factors.blackbox;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.PositionSavingContainerFactory;
import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.mail.so.factors.SoFactorFieldAccessorBase;
import ru.yandex.mail.so.factors.types.JsonMapSoFactorType;
import ru.yandex.mail.so.factors.types.JsonObjectSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;

public enum BlackboxUserinfoSoFactorType
    implements SoFactorType<BlackboxUserinfo>
{
    USERINFO;

    @Override
    public BlackboxUserinfo cast(final Object value) {
        if (value instanceof BlackboxUserinfo) {
            return (BlackboxUserinfo) value;
        } else {
            return null;
        }
    }

    @Override
    public SoFactorFieldAccessorBase fieldAccessorFor(final String fieldName) {
        switch (fieldName) {
            case "__json_map__":
                return new JsonAccessor(
                    this,
                    JsonMapSoFactorType.JSON_MAP,
                    '.' + fieldName);
            case "__json_object__":
                return new JsonAccessor(
                    this,
                    JsonObjectSoFactorType.JSON_OBJECT,
                    '.' + fieldName);
            default:
                return null;
        }
    }

    public static class JsonAccessor extends SoFactorFieldAccessorBase {
        public JsonAccessor(
            final SoFactorType<?> variableType,
            final SoFactorType<?> fieldType,
            final String stringValue)
        {
            super(variableType, fieldType, stringValue);
        }

        @Override
        public JsonMap extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof BlackboxUserinfo) {
                return ((BlackboxUserinfo) value)
                    .toJsonObject(PositionSavingContainerFactory.INSTANCE);
            }
            return null;
        }
    }
}

