package ru.yandex.mail.so.factors.blackbox;

import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractor;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.LongSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public enum BlackboxUserinfoUidExtractor
    implements SoFactorsExtractor
{
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(BlackboxUserinfoSoFactorType.USERINFO);
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(LongSoFactorType.LONG);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        BlackboxUserinfo userinfo =
            inputs.get(0, BlackboxUserinfoSoFactorType.USERINFO);
        if (userinfo == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        callback.completed(
            Collections.singletonList(
                LongSoFactorType.LONG.createFactor(userinfo.uid())));
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            BlackboxUserinfoSoFactorType.USERINFO);
        registry.typesRegistry().registerSoFactorType(LongSoFactorType.LONG);
    }
}

