package ru.yandex.mail.so.factors.blackbox;

import java.util.HashMap;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.json.dom.ContainerFactory;
import ru.yandex.json.dom.JsonMap;

public class BlackboxUserinfosMap extends HashMap<String, BlackboxUserinfo> {
    private static final long serialVersionUID = 0L;

    public BlackboxUserinfosMap(final int capacity) {
        super(capacity);
    }

    public JsonMap toJsonObject(final ContainerFactory containerFactory) {
        JsonMap result = new JsonMap(containerFactory, size() << 1);
        for (Entry<String, BlackboxUserinfo> entry: entrySet()) {
            BlackboxUserinfo userinfo = entry.getValue();
            JsonMap value;
            if (userinfo == null) {
                value = JsonMap.EMPTY;
            } else {
                value = userinfo.toJsonObject(containerFactory);
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }
}
