package ru.yandex.mail.so.factors.config;

import java.io.File;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractExtractModuleConfigBuilder
    <T extends AbstractExtractModuleConfigBuilder<T>>
    implements ConfigBuilder<T>, ExtractModuleConfig
{
    private String entryPoint;
    private File dslScript;

    protected AbstractExtractModuleConfigBuilder(
        final ExtractModuleConfig config)
    {
        entryPoint(config.entryPoint());
        dslScript(config.dslScript());
    }

    protected AbstractExtractModuleConfigBuilder(
        final IniConfig config,
        final ExtractModuleConfig defaults)
        throws ConfigException
    {
        entryPoint = ENTRY_POINT.extract(config, defaults.entryPoint());
        dslScript = DSL_SCRIPT.extract(config, defaults.dslScript());
    }

    @Override
    public String entryPoint() {
        return entryPoint;
    }

    public T entryPoint(final String entryPoint) {
        this.entryPoint = entryPoint;
        return self();
    }

    @Override
    public File dslScript() {
        return dslScript;
    }

    public T dslScript(final File dslScript) {
        this.dslScript = dslScript;
        return self();
    }
}

