package ru.yandex.mail.so.factors.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractExtractModulesConfigBuilder
    <T extends AbstractExtractModulesConfigBuilder<T>>
    implements ConfigBuilder<T>, ExtractModulesConfig
{
    private Map<String, ExtractModuleConfigBuilder> extractModules;

    protected AbstractExtractModulesConfigBuilder(
        final ExtractModulesConfig config)
    {
        extractModules(config.extractModules());
    }

    protected AbstractExtractModulesConfigBuilder(
        final IniConfig config,
        final ExtractModulesConfig defaults)
        throws ConfigException
    {
        IniConfig extractModulesSection = config.section("extract-module");
        Set<String> extractModules = extractModulesSection.sections().keySet();
        this.extractModules = new LinkedHashMap<>(extractModules.size() << 1);
        // Ignore defaults
        for (String extractModule: extractModules) {
            this.extractModules.put(
                extractModule,
                ExtractModulesConfig.extractModuleParser(extractModule)
                    .extract(
                        extractModulesSection,
                        ExtractModuleConfigDefaults.INSTANCE));
        }
    }

    @Override
    public Map<String, ExtractModuleConfigBuilder> extractModules() {
        return extractModules;
    }

    public T extractModules(
        final Map<String, ? extends ExtractModuleConfig> extractModules)
    {
        this.extractModules = new LinkedHashMap<>(extractModules.size() << 1);
        for (Map.Entry<String, ? extends ExtractModuleConfig> entry
            : extractModules.entrySet())
        {
            this.extractModules.put(
                entry.getKey(),
                new ExtractModuleConfigBuilder(entry.getValue()));
        }
        return self();
    }
}

