package ru.yandex.mail.so.factors.config;

import java.io.File;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableExtractModuleConfig
    implements ExtractModuleConfig, ImmutableConfig
{
    private final String entryPoint;
    private final File dslScript;

    public ImmutableExtractModuleConfig(final ExtractModuleConfig config)
        throws ConfigException
    {
        entryPoint = ENTRY_POINT.validate(config.entryPoint());
        dslScript = DSL_SCRIPT.validate(config.dslScript());
    }

    @Override
    public String entryPoint() {
        return entryPoint;
    }

    @Override
    public File dslScript() {
        return dslScript;
    }
}

