package ru.yandex.mail.so.factors.config;

import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableExtractModulesConfig
    implements ExtractModulesConfig, ImmutableConfig
{
    private final Map<String, ImmutableExtractModuleConfig> extractModules;

    public ImmutableExtractModulesConfig(final ExtractModulesConfig config)
        throws ConfigException
    {
        Map<String, ? extends ExtractModuleConfig> extractModules =
            config.extractModules();
        this.extractModules = new LinkedHashMap<>(extractModules.size() << 1);
        for (Map.Entry<String, ? extends ExtractModuleConfig> entry
            : extractModules.entrySet())
        {
            String name = entry.getKey();
            ImmutableExtractModuleConfig extractModule =
                ExtractModulesConfig.extractModuleParser(name)
                    .validate(entry.getValue());
            this.extractModules.put(name, extractModule);
        }
    }

    @Override
    public Map<String, ImmutableExtractModuleConfig> extractModules() {
        return extractModules;
    }
}

