package ru.yandex.mail.so.factors.dsl;

import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.types.BooleanSoFactorType;
import ru.yandex.mail.so.factors.types.DoubleSoFactorType;
import ru.yandex.mail.so.factors.types.LongSoFactorType;
import ru.yandex.mail.so.factors.types.NullSoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;

public class SoCallArgument {
    public enum Type {
        TOKEN {
            @Override
            public SoFactor<?> createFactor(final String image)
                throws ConfigException
            {
                throw new ConfigException("Unsupported const type");
            }
        },
        NULL {
            @Override
            public SoFactor<?> createFactor(final String image) {
                return NullSoFactorType.NULL_FACTOR;
            }
        },
        NUMBER {
            @Override
            public SoFactor<?> createFactor(final String image)
                throws ConfigException
            {
                try {
                    if (image.indexOf('.') != -1 || image.indexOf('e') != -1) {
                        return new SoFactor<>(
                            DoubleSoFactorType.DOUBLE,
                            Double.valueOf(image));
                    } else {
                        return new SoFactor<>(
                            LongSoFactorType.LONG,
                            Long.valueOf(image));
                    }
                } catch (RuntimeException e) {
                    throw new ConfigException(
                        "Failed to parse number const from <" + image + '>',
                        e);
                }
            }
        },
        BOOLEAN {
            @Override
            public SoFactor<?> createFactor(final String image) {
                if (image.equals("true")) {
                    return BooleanSoFactorType.TRUE;
                } else {
                    return BooleanSoFactorType.FALSE;
                }
            }
        },
        STRING {
            @Override
            public SoFactor<?> createFactor(final String image) {
                return new SoFactor<>(StringSoFactorType.STRING, image);
            }
        };

        public abstract SoFactor<?> createFactor(String image)
            throws ConfigException;
    };

    // TODO: Declaration must store file name and line number
    private final String image;
    private final Type type;

    public SoCallArgument(final String image, final Type type) {
        this.image = image.intern();
        this.type = type;
    }

    public String image() {
        return image;
    }

    public Type type() {
        return type;
    }

    @Override
    public String toString() {
        return type.toString() + '{' + image + '}';
    }
}

