package ru.yandex.mail.so.factors.dsl;

import java.util.List;

public class SoCallDeclaration {
    // TODO: Declaration must store file name and line number
    private final String functionName;
    private final String alias;
    private final boolean trace;
    private final boolean async;
    private final boolean critical;
    private final List<SoCallArgument> arguments;
    private final List<String> outputs;

    public SoCallDeclaration(
        final String functionName,
        final String alias,
        final boolean trace,
        final boolean async,
        final boolean critical,
        final List<SoCallArgument> arguments,
        final List<String> outputs)
    {
        this.functionName = functionName;
        this.alias = alias;
        this.trace = trace;
        this.async = async;
        this.critical = critical;
        this.arguments = arguments;
        this.outputs = outputs;
    }

    public String functionName() {
        return functionName;
    }

    public String alias() {
        return alias;
    }

    public boolean trace() {
        return trace;
    }

    public boolean async() {
        return async;
    }

    public boolean critical() {
        return critical;
    }

    public List<SoCallArgument> arguments() {
        return arguments;
    }

    public List<String> outputs() {
        return outputs;
    }
}

