package ru.yandex.mail.so.factors.dsl;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.parser.config.ConfigException;

public class SoConsts {
    private final Map<SoCallArgument.Type, Map<String, SoConst>> consts =
        new EnumMap<>(SoCallArgument.Type.class);
    private final List<SoFactor<?>> constsList = new ArrayList<>();

    public SoConsts() {
        for (SoCallArgument.Type type: SoCallArgument.Type.values()) {
            if (type != SoCallArgument.Type.TOKEN) {
                consts.put(type, new HashMap<>());
            }
        }
    }

    public void addConst(final SoCallArgument argument)
        throws ConfigException
    {
        SoCallArgument.Type type = argument.type();
        if (type != SoCallArgument.Type.TOKEN) {
            Map<String, SoConst> map = consts.get(type);
            String image = argument.image();
            SoConst constValue = map.get(image);
            if (constValue == null) {
                int id = constsList.size();
                SoFactor<?> factor = type.createFactor(image);
                map.put(image, new SoConst(id, factor));
                if (type == SoCallArgument.Type.NULL) {
                    constsList.add(null);
                } else {
                    constsList.add(factor);
                }
            }
        }
    }

    public SoConst getConst(final SoCallArgument argument)
        throws ConfigException
    {
        Map<String, SoConst> map = consts.get(argument.type());
        SoConst constValue = map.get(argument.image());
        if (constValue == null) {
            throw new ConfigException("Can't find const " + argument);
        }
        return constValue;
    }

    public int size() {
        return constsList.size();
    }

    public List<SoFactor<?>> constsList() {
        return constsList;
    }
}

