package ru.yandex.mail.so.factors.dsl;

import ru.yandex.mail.so.factors.IdentitySoFactorFieldAccessor;
import ru.yandex.mail.so.factors.SoFactorFieldAccessor;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.xpath.PathConsumer;

public class ValueInfo implements PathConsumer<ConfigException> {
    private final SoVariables variables;
    private final String description;
    private SoVariableInfo variableInfo = null;
    private SoFactorFieldAccessor fieldAccessor = null;

    public ValueInfo(
        final SoVariables variables,
        final String description)
    {
        this.variables = variables;
        this.description = description;
    }

    public SoVariableInfo variableInfo() {
        return variableInfo;
    }

    public SoFactorFieldAccessor fieldAccessor() {
        return fieldAccessor;
    }

    @Override
    public ConfigException parseFailedException(final String message) {
        return new ConfigException(description + " parse failed: " + message);
    }

    @Override
    public ConfigException parseFailedException(
        final String message,
        final Throwable cause)
    {
        return new ConfigException(
            description + " parse failed: " + message,
            cause);
    }

    @Override
    public void name(final String name) throws ConfigException {
        if (variableInfo == null) {
            variableInfo = variables.getVariableInfo(name, description);
            fieldAccessor =
                new IdentitySoFactorFieldAccessor(variableInfo.type());
        } else {
            SoFactorType<?> type = fieldAccessor.fieldType();
            SoFactorFieldAccessor newFieldAccessor =
                type.fieldAccessorFor(name);
            if (newFieldAccessor == null) {
                throw new ConfigException(
                    description + " doesn't have field <"
                    + name + "> in type " + type);
            }
            fieldAccessor = fieldAccessor.andThen(newFieldAccessor);
        }
    }

    @Override
    public void index(final int index) throws ConfigException {
        if (variableInfo == null) {
            throw new ConfigException(
                description + " can't be accessed by index without variable");
        } else {
            SoFactorType<?> type = fieldAccessor.fieldType();
            SoFactorFieldAccessor newFieldAccessor =
                type.fieldAccessorFor(index);
            if (newFieldAccessor == null) {
                throw new ConfigException(
                    description + " doesn't have index " + index
                    + " in type " + type);
            }
            fieldAccessor = fieldAccessor.andThen(newFieldAccessor);
        }
    }

    @Override
    public void anyIndex() throws ConfigException {
        throw new ConfigException("Any index matching is not supported");
    }
}

