package ru.yandex.mail.so.factors.dssm;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractDssmExtractorConfigBuilder
    <T extends AbstractDssmExtractorConfigBuilder<T>>
    implements ConfigBuilder<T>, DssmExtractorConfig
{
    private File model;
    private String layer;
    private Map<String, String> fieldsMapping;
    private boolean preprocessFields;

    protected AbstractDssmExtractorConfigBuilder(
        final DssmExtractorConfig config)
    {
        model(config.model());
        layer(config.layer());
        fieldsMapping(config.fieldsMapping());
        preprocessFields(config.preprocessFields());
    }

    protected AbstractDssmExtractorConfigBuilder(
        final IniConfig config,
        final DssmExtractorConfig defaults)
        throws ConfigException
    {
        model = MODEL.extract(config, defaults.model());
        layer = LAYER.extract(config, defaults.layer());
        fieldsMapping =
            FIELDS_MAPPING.extract(config, defaults.fieldsMapping());
        preprocessFields =
            PREPROCESS_FIELDS.extract(config, defaults.preprocessFields());
    }

    @Override
    public File model() {
        return model;
    }

    public T model(final File model) {
        this.model = model;
        return self();
    }

    @Override
    public String layer() {
        return layer;
    }

    public T layer(final String layer) {
        this.layer = layer;
        return self();
    }

    @Override
    public Map<String, String> fieldsMapping() {
        return fieldsMapping;
    }

    public T fieldsMapping(final Map<String, String> fieldsMapping) {
        this.fieldsMapping = new LinkedHashMap<>(fieldsMapping);
        return self();
    }

    @Override
    public boolean preprocessFields() {
        return preprocessFields;
    }

    public T preprocessFields(final boolean preprocessFields) {
        this.preprocessFields = preprocessFields;
        return self();
    }
}

