package ru.yandex.mail.so.factors.dssm;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.config.ParameterMapConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.FileParser;
import ru.yandex.parser.string.InputFileValidator;
import ru.yandex.parser.string.NonEmptyValidator;

public interface DssmExtractorConfig {
    ParameterConfig<File> MODEL = new ParameterConfig<>(
        "model",
        FileParser.INSTANCE,
        InputFileValidator.INSTANCE);
    ParameterConfig<String> LAYER = new ParameterConfig<>(
        "layer",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterMapConfig<String> FIELDS_MAPPING = new ParameterMapConfig<>(
        "fields-mapping",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE,
        size -> new LinkedHashMap<>(size << 1));
    ParameterConfig<Boolean> PREPROCESS_FIELDS = new ParameterConfig<>(
        "preprocess-fields",
        BooleanParser.INSTANCE,
        GenericFunction.identity());

    File model();

    String layer();

    Map<String, String> fieldsMapping();

    boolean preprocessFields();
}

