package ru.yandex.mail.so.factors.dssm;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class DssmExtractorConfigBuilder
    extends AbstractDssmExtractorConfigBuilder<DssmExtractorConfigBuilder>
{
    public DssmExtractorConfigBuilder() {
        super(DssmExtractorConfigDefaults.INSTANCE);
    }

    public DssmExtractorConfigBuilder(final DssmExtractorConfig config) {
        super(config);
    }

    public DssmExtractorConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, DssmExtractorConfigDefaults.INSTANCE);
    }

    public DssmExtractorConfigBuilder(
        final IniConfig config,
        final DssmExtractorConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public DssmExtractorConfigBuilder self() {
        return this;
    }

    public ImmutableDssmExtractorConfig build() throws ConfigException {
        return new ImmutableDssmExtractorConfig(this);
    }
}

