package ru.yandex.mail.so.factors.dssm;

import java.io.File;
import java.util.Map;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableDssmExtractorConfig
    implements DssmExtractorConfig, ImmutableConfig
{
    private final File model;
    private final String layer;
    private final Map<String, String> fieldsMapping;
    private final boolean preprocessFields;

    public ImmutableDssmExtractorConfig(final DssmExtractorConfig config)
        throws ConfigException
    {
        model = MODEL.validate(config.model());
        layer = LAYER.validate(config.layer());
        fieldsMapping = FIELDS_MAPPING.validate(config.fieldsMapping());
        preprocessFields =
            PREPROCESS_FIELDS.validate(config.preprocessFields());
    }

    @Override
    public File model() {
        return model;
    }

    @Override
    public String layer() {
        return layer;
    }

    @Override
    public Map<String, String> fieldsMapping() {
        return fieldsMapping;
    }

    @Override
    public boolean preprocessFields() {
        return preprocessFields;
    }
}

