package ru.yandex.mail.so.factors.eml2html;

import java.io.File;
import java.io.IOException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.sanitizer2.config.SanitizingConfig;
import ru.yandex.sanitizer2.config.SanitizingConfigBuilder;
import ru.yandex.util.storage.AbstractDataExtractorConfigBuilder;

public abstract class AbstractEml2HtmlConfigBuilder
    <T extends AbstractEml2HtmlConfigBuilder<T>>
    extends AbstractDataExtractorConfigBuilder<T>
    implements Eml2HtmlConfig
{
    private SanitizingConfigBuilder sanitizingConfig;

    protected AbstractEml2HtmlConfigBuilder(final Eml2HtmlConfig config) {
        super(config);
        sanitizingConfig(config.sanitizingConfig());
    }

    protected AbstractEml2HtmlConfigBuilder(
        final IniConfig config,
        final Eml2HtmlConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        File sanitizingConfig = config.getInputFile("sanitizing-config", null);
        if (sanitizingConfig == null) {
            this.sanitizingConfig = null;
        } else {
            try {
                this.sanitizingConfig =
                    new SanitizingConfigBuilder(
                        new IniConfig(sanitizingConfig));
            } catch (IOException e) {
                throw new ConfigException(
                    "Failed to load sanitizing config from file "
                    + sanitizingConfig,
                    e);
            }
        }
    }

    @Override
    public SanitizingConfigBuilder sanitizingConfig() {
        return sanitizingConfig;
    }

    public T sanitizingConfig(final SanitizingConfig sanitizingConfig) {
        if (sanitizingConfig == null) {
            this.sanitizingConfig = null;
        } else {
            this.sanitizingConfig =
                new SanitizingConfigBuilder(sanitizingConfig);
        }
        return self();
    }
}

