package ru.yandex.mail.so.factors.eml2html;

import ru.yandex.sanitizer2.HtmlCDataTag;
import ru.yandex.sanitizer2.HtmlNodeVisitor;
import ru.yandex.sanitizer2.HtmlTag;
import ru.yandex.sanitizer2.HtmlText;

public class BlockquoteCountingVisitor
    implements HtmlNodeVisitor<Void, RuntimeException>
{
    private int count = 0;

    public int count() {
        return count;
    }

    @Override
    public Void visit(final HtmlTag tag) {
        if (count < 2) {
            boolean blockquote = "blockquote".equals(tag.tagName());
            if (blockquote) {
                ++count;
            } else {
                int size = tag.size();
                for (int i = 0; i < size; ++i) {
                    tag.get(i).accept(this);
                }
            }
        }
        return null;
    }

    @Override
    public Void visit(final HtmlCDataTag cdata) {
        return null;
    }

    @Override
    public Void visit(final HtmlText text) {
        return null;
    }
}

