package ru.yandex.mail.so.factors.eml2html;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.sanitizer2.HtmlCDataTag;
import ru.yandex.sanitizer2.HtmlNode;
import ru.yandex.sanitizer2.HtmlNodeVisitor;
import ru.yandex.sanitizer2.HtmlTag;
import ru.yandex.sanitizer2.HtmlText;

public enum BlockquoteErasingVisitor
    implements HtmlNodeVisitor<HtmlNode, RuntimeException>
{
    INSTANCE;

    @Override
    public HtmlTag visit(final HtmlTag tag) {
        String tagName = tag.tagName();
        if ("blockquote".equals(tagName)) {
            return null;
        } else {
            int size = tag.size();
            for (int i = 0; i < size; ++i) {
                HtmlNode before = tag.get(i);
                HtmlNode after = before.accept(this);
                if (after != before) {
                    // Copy unmodified nodes
                    List<HtmlNode> nodes = new ArrayList<>(size);
                    for (int j = 0; j < i; ++j) {
                        nodes.add(tag.get(j));
                    }
                    // Now, process all other nodes
                    if (after != null) {
                        nodes.add(after);
                    }
                    for (int j = i + 1; j < size; ++j) {
                        after = tag.get(j).accept(this);
                        if (after != null) {
                            nodes.add(after);
                        }
                    }
                    return new HtmlTag(
                        nodes,
                        tag.escaping(),
                        tagName,
                        tag.classes(),
                        tag.sanitizedClasses(),
                        tag.id(),
                        tag.sanitizedId(),
                        tag.attrs(),
                        tag.style());
                }
            }
            return tag;
        }
    }

    @Override
    public HtmlCDataTag visit(final HtmlCDataTag cdata) {
        return cdata;
    }

    @Override
    public HtmlText visit(final HtmlText text) {
        return text;
    }
}

