package ru.yandex.mail.so.factors.eml2html;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class Eml2HtmlConfigBuilder
    extends AbstractEml2HtmlConfigBuilder<Eml2HtmlConfigBuilder>
{
    public Eml2HtmlConfigBuilder() {
        super(Eml2HtmlConfigDefaults.INSTANCE);
    }

    public Eml2HtmlConfigBuilder(final Eml2HtmlConfig config) {
        super(config);
    }

    public Eml2HtmlConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, Eml2HtmlConfigDefaults.INSTANCE);
    }

    public Eml2HtmlConfigBuilder(
        final IniConfig config,
        final Eml2HtmlConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public Eml2HtmlConfigBuilder self() {
        return this;
    }

    public ImmutableEml2HtmlConfig build() throws ConfigException {
        return new ImmutableEml2HtmlConfig(this);
    }
}

